<?php

/********************************************************************************??
 *
 *  Invite Only Threads.
 *  Author: Pratik Unadkat (mybblabs.com)
 *  Copyright: © 2012 Pratik Unadkat (crazy4cs)
 *  
 *  Website: http://www.mybblabs.com/
 *  License: www.mybblabs.com/license.php
 *  Any codes in this plugin are copyrighted and not allowed to be reproduced or distributed.
 * 
 *  Allows a user to define who can view his thread.
 *  
 *  v1.3 : Now uses one query less and done some bug fixes.
 **********************************************************************************/

if(!defined("IN_MYBB"))
	die("This file cannot be accessed directly.");
	
$plugins->add_hook("newthread_start", "iot_newthread_display");
$plugins->add_hook('datahandler_post_validate_thread', 'iot_newthread_validate');
$plugins->add_hook("datahandler_post_insert_thread", "iot_newthread_action");
$plugins->add_hook("editpost_action_start", "iot_editpost_display");
$plugins->add_hook("editpost_do_editpost_start", "iot_editpost_action");
$plugins->add_hook("showthread_start", "iot_check");
$plugins->add_hook("newreply_start", "iot_reply_check");

function iot_info()
{
    return array(
        "name"            => "هاك مواضيع خاصه بالدعوات",
        "description"    => "يعمل علي اضافة امكانية لجعل مواضيع معينه تعرض عن طريق دعوة اعضاء معينه لمشاهدته.",
        "website"        => "http://www.mybblabs.com",
        "version"        => "1.3",
        "author"        => "Pratik Unadkat",
        "authorsite"    => "http://www.mybblabs.com",
        "compatibility"  => "*",
        'guid'        => "62ca85866945ed4274e7f3dfb2166150"
    );
}

function iot_install()
{

global $db;

$db->query("ALTER TABLE ".TABLE_PREFIX."threads ADD inviteonlycheck INT(1) NOT NULL");
$db->query("ALTER TABLE ".TABLE_PREFIX."threads ADD inviteonlyuids TEXT NOT NULL");
	
$iot = array(
        'name' => 'iot',
        'title' => 'هاك مواضعي خاصه بالدعوات',
        'description' => 'اعدادات الهاك.',
        'disporder' => '999',
        'isdefault' => 'no'
    );
    $db->insert_query('settinggroups',$iot);
    $gid = $db->insert_id();
    
    
    $iot2 = array(
        "name" => "iot_enabled",
        "title" => "تفعيل الهاك",
        "description" => "اختار تفعيل او ايقاف الهاك.",
        "optionscode" => "yesno",
        "value" => "0",
        "disporder" => "2",
        "gid" => intval($gid),
        );
    $db->insert_query("settings", $iot2);
	
	$iot3 = array(
        "name" => "iot_fid",
        "title" => "الاقسام المسموح له",
        "description" => "اكتب رقم القسم المراد تشغيل الهاك به .",
        "optionscode" => "text",
        "value" => "",
        "disporder" => "3",
        "gid" => intval($gid),
        );
    $db->insert_query("settings", $iot3);
	
	$iot4 = array(
        "name" => "iot_usergroup",
        "title" => "مجموعات الاعضاء المسموحة",
        "description" => "اكتب هنا رقم المجموعة الخاصه بالاعضاء المراد تفعيل هذه الميزة لهم.",
        "optionscode" => "text",
        "value" => "",
        "disporder" => "4",
        "gid" => intval($gid),
        );
    $db->insert_query("settings", $iot4);
	
		$template1 = array(
		"title"		=> "inviteonlythreads",
		"template"	=> '<tr>
<td class=\"trow2\" valign=\"top\"><strong>{$lang->iot_title}</strong></td>
<td class=\"trow2\"><span class=\"smalltext\">
<label><input type=\"checkbox\" class=\"checkbox\" name=\"inviteonlycheck\" value=\"1\" {$checked}/>&nbsp;{$lang->iot_cbox_label}</label><br />
<input type=\"text\" class=\"textbox\" name=\"inviteonlyuids\" size=\"40\" value=\"{$existinguids}\" tabindex=\"1\" /><br />
{$lang->iot_tbox_note}
</span></td>
</tr>',
		"sid"		=> -1
	);
	$db->insert_query("templates", $template1);
        
rebuild_settings();	
	
}

function iot_is_installed()
{

	global $db;
	
	if($db->field_exists("inviteonlycheck", "threads") && $db->field_exists("inviteonlyuids", "threads"))
	{
		return true;
	}
	
	return false;
}

function iot_activate()
{
    global $mybb;

    require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("newthread", '#{\$modoptions}#', "{\$modoptions}{\$iot}");
	find_replace_templatesets("editpost", '#{\$disablesmilies}#', "{\$disablesmilies}{\$iot}");

}

function iot_deactivate()
{
    global $mybb;

    require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("newthread", '#'.preg_quote('{$iot}').'#', '',0);
	find_replace_templatesets("editpost", '#'.preg_quote('{$iot}').'#', '',0);

}

function iot_uninstall()
{
    global $db;
	
$db->query("ALTER TABLE ".TABLE_PREFIX."threads DROP `inviteonlycheck`");	
$db->query("ALTER TABLE ".TABLE_PREFIX."threads DROP `inviteonlyuids`");	

$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='iot'");  
$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='iot_enabled'");
$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='iot_fid'");
$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='iot_usergroup'");
$db->delete_query("templates","title = 'inviteonlythreads'");

rebuild_settings();
	
}

function iot_perms($grp)
{
	global $mybb;
	
	if ($grp == '')
		return false;
		
	$groups = explode(",", $grp);
	
	$iotgroups = explode(",", $mybb->user['additionalgroups']);
	$iotgroups[] = $mybb->user['usergroup'];

	if(count(array_intersect($iotgroups, $groups)) == 0)
		return false;
	else
		return true;
}

//Eval when creating new thread

function iot_newthread_display()
{
    global $mybb, $templates, $iot, $lang;
	
	$lang->load("iot");

	$fid = intval($mybb->input['fid']);
	$forums = explode(",",$mybb->settings['iot_fid']);
	$iot_groups = $mybb->settings['iot_usergroup'];
	
	if($mybb->settings['iot_enabled'] == "1" AND iot_perms($iot_groups) AND in_array($fid, $forums))
	{
	eval("\$iot = \"".$templates->get("inviteonlythreads")."\";");
    }

}

function iot_newthread_validate(&$dh)
{
    global $mybb;

    if($mybb->input['inviteonlycheck'])
    {
        $dh->data['inviteonlycheck'] = $mybb->input['inviteonlycheck'];
		$dh->data['inviteonlyuids'] = $mybb->input['inviteonlyuids'];
    }
} 




function iot_newthread_action(&$dh)
{
    global $mybb, $lang, $db;
	
	if($mybb->input['inviteonlycheck'] == 1)
	{
	$inviteonlyuids = $mybb->input['inviteonlyuids'];
	
	$lang->load("iot");
	
	if($inviteonlyuids == "")
	 {
	 error($lang->iot_no_uids);
	 }
	 
	}
	 
     //else{$db->query("UPDATE ".TABLE_PREFIX."threads SET inviteonlycheck=1 AND inviteonlyuids='".$db->escape_string(intval($mybb->input['inviteonlyuids']))."' WHERE tid='".$posthandler->tid."'");}
	 
	 
	 
if($dh->action == 'thread' && $dh->method == 'insert')
    {
        $dh->thread_insert_data['inviteonlycheck'] = $db->escape_string($dh->data['inviteonlycheck']);
        $dh->thread_insert_data['inviteonlyuids'] = $db->escape_string($dh->data['inviteonlyuids']);
    }	 
			
}

//OP is editing his thread

function iot_editpost_display()
{
    global $mybb, $templates, $iot, $db, $existinguids, $checked, $post, $lang;
	
	$lang->load("iot");
	
	$fid = intval($post['fid']);
	$forums = explode(",", $mybb->settings['iot_fid']);
	$iot_groups = $mybb->settings['iot_usergroup'];
	
	$query = $db->query("SELECT tid, inviteonlycheck, inviteonlyuids, firstpost FROM ".TABLE_PREFIX."threads where tid='".$post['tid']."'");
	
	while($do = $db->fetch_array($query))
	{
	$existinguids = $do['inviteonlyuids'];
	$GLOBALS['inviteonlyuids'] = $existinguids;
	
	if($do['inviteonlycheck'] == 1)
	{
	$checked = 'checked="checked"';
	}
	$firstpost = $do['firstpost'];
	}
	
	if($mybb->settings['iot_enabled'] == "1" AND iot_perms($iot_groups) AND in_array($fid, $forums) AND $post['uid'] == $mybb->user['uid'] || is_moderator($fid) AND $firstpost == $post['pid'])
	{
	eval("\$iot = \"".$templates->get("inviteonlythreads")."\";");
    }

}	

function iot_editpost_action()
{
    global $mybb, $lang, $thread, $db, $post;
	
	$val = $mybb->input['inviteonlyuids'];
	$tid = $thread['tid'];
	
	if($mybb->input['inviteonlycheck'] == 1)
	{
	$lang->load("iot");
	
	 if($val == "")
	 {
	 error($lang->iot_no_uids);
	 }

	 
     $db->query("UPDATE ".TABLE_PREFIX."threads SET inviteonlycheck=1, inviteonlyuids='".$db->escape_string($val)."' WHERE tid='".$post['tid']."'");	 
	
	 
	} 
	
	if($mybb->input['inviteonlycheck'] == 0)
	{
	
	$db->query("UPDATE ".TABLE_PREFIX."threads SET inviteonlycheck=0, inviteonlyuids='".$db->escape_string($val)."' WHERE tid='".$post['tid']."'");
	}
			
}

//We now have completed major tasking, time for action

function iot_check()
{
global $mybb, $lang, $thread;

$tid = $thread['tid'];
$checkit = $thread['inviteonlycheck'];
$check_uids = $thread['inviteonlyuids'];
$uids_list = explode(",", $check_uids);
$iot_groups = $mybb->settings['iot_usergroup'];
$fid = $thread['fid'];
$forums = explode(",", $mybb->settings['iot_fid']);

if($mybb->settings['iot_enabled'] == "1")
{
if($checkit == "1" && !in_array($mybb->user['uid'], $uids_list) && in_array($fid, $forums) && (!$thread['uid'] == $mybb->user['uid'] || !is_moderator($fid)))
{
$lang->load("iot");

error($lang->iot_thread_error);
}
}

}

function iot_reply_check()
{
global $mybb, $lang, $thread;

$tid = $thread['tid'];
$checkit = $thread['inviteonlycheck'];
$check_uids = $thread['inviteonlyuids'];
$uids_list = explode(",", $check_uids);
$iot_groups = $mybb->settings['iot_usergroup'];
$fid = $thread['fid'];
$forums = explode(",", $mybb->settings['iot_fid']);

if($mybb->settings['iot_enabled'] == "1" && $checkit == "1" && !in_array($mybb->user['uid'], $uids_list)  && in_array($fid, $forums) && (!$thread['uid'] == $mybb->user['uid'] || !is_moderator($fid)))
{
$lang->load("iot");

error($lang->iot_thread_error);
}

}		
	
?>